/*****************************************************************************
*  LPC15xx RC5 transmit demo program for MicroCore100 rev A board
*
*  1. Use SCT0 timer to send encoded RC5 frames @ SCT0_OUT0 (P0_11)
*  2. Use S2 (P2_5) key to send key code
*  3. Use MRT to generate timeout delay between RC5 frames
*****************************************************************************/
#include "LPC15xx.h"

extern void RC5_Init(void);
extern void RC5_Send(uint16_t fr);

void MRT_IRQHandler(void)
{
    LPC_MRT->Channel[0].STAT = 1;                          // acknowledge MRT irq
}

void MRT_Init(void) 
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= (1 << 0);                // enable MRT clock

    LPC_MRT->Channel[0].INTVAL  = (SystemCoreClock / 8);   // 1/8 sec (125 msec) timeout
    LPC_MRT->Channel[0].INTVAL |= (1U << 31);
    LPC_MRT->Channel[0].CTRL    = (1 << 0) | (0 << 1);     // enable + repeated mode
    NVIC_EnableIRQ(MRT_IRQn);                              // enable Multi-Rate timer irq
}

int main(void) 
{
  static uint8_t  trg = 1;
  static uint8_t  tgl = 1;
  static uint16_t frame;

    LPC_SYSCON->SYSAHBCLKCTRL0 |= (1 << 11) |              // enable the PMUX clock
                                  (1 << 12) |              // enable the SWM clock
                                  (1 << 13) |              // enable the IOCON clock
                                  (1 << 16);               // enable clock to GPIO port 2
    MRT_Init();
    RC5_Init();

    while (1)
    {
        frame = (1   << 13) |                              // set start (S) bit
                (1   << 12) |                              // set field (F) bit
                (tgl << 11) |                              // clr control / toggle (C) bit
                (20  << 6 ) |                              // system  = 20
                (9   << 0 );                               // command = 9

        if (!(LPC_GPIO->PIN[2] & (1 << 5)))                // P2_5 high to low?
        {
            if (trg)
            {
                trg = 0;                                   // trigger P2_5 low
            }
            RC5_Send(frame);
        }
        else if ((LPC_GPIO->PIN[2] & (1 << 5)) && !trg)    // P2_5 low to high?
        {
            trg = 1;                                       // trigger P2_5 high
            tgl = !tgl;                                    // toggle RC5 control bit
        }

//        __wfi();                                           // goto sleep
    }
}
